/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.small;

import BryceMath.Calculations.Colors;
import BryceMath.Calculations.MathB;
import BryceMath.Geometry.Rectangle;
import Game_Engine.GUI.Components.small.gui_label;
import Game_Engine.GUI.Interfaces.Pingable;
import Game_Engine.GUI.Sprites.StyleSpec;
import java.awt.Color;

public class gui_handle
extends gui_label
implements Pingable {
    public static gui_handle handle_held;
    protected boolean dragged = false;
    private boolean changed = false;
    private boolean revert;
    private int savedDepth;
    private int holdX;
    private int holdY;
    private int min_x = Integer.MIN_VALUE;
    private int max_x = Integer.MAX_VALUE;
    private int min_y = Integer.MIN_VALUE;
    private int max_y = Integer.MAX_VALUE;
    public static final Color C_DRAGGABLE;
    private Color C_DRAGGED = StyleSpec.C_DRAGGED;

    static {
        C_DRAGGABLE = Colors.Color_hsv(60.0, 5.0, 100.0);
    }

    public gui_handle(double x, double y, int w, int h) {
        super(x, y, w, h);
        this.iVars();
    }

    public gui_handle(Rectangle r) {
        super(r);
        this.iVars();
    }

    private void iVars() {
        this.setRestingColor(C_DRAGGABLE);
        this.padding = 0;
    }

    @Override
    public void initialize() {
        super.initialize();
        int room_h = this.myContainer.getH();
        int room_w = this.myContainer.getW();
        this.min_x = Math.max(this.min_x, 0);
        this.min_y = Math.max(this.min_y, 0);
        this.max_x = Math.min(this.max_x, room_w - this.getW());
        this.max_y = Math.min(this.max_y, room_h - this.getH());
    }

    @Override
    public void mouseP(int mx, int my) {
        if (this.dragged) {
            return;
        }
        this.holdX = (int)((double)mx - this.getX());
        this.holdY = (int)((double)my - this.getY());
        this.enterDragMode();
    }

    @Override
    public void global_mouseR() {
        if (this.dragged) {
            this.exitDragMode();
        }
    }

    @Override
    public void global_mouseD(int mx, int my) {
        if (!this.dragged) {
            return;
        }
        this.setX(MathB.max(this.min_x, MathB.min(this.max_x, mx - this.holdX)));
        this.setY(MathB.max(this.min_y, MathB.min(this.max_y, my - this.holdY)));
        this.changed = true;
    }

    @Override
    public boolean flag() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    @Override
    public void setFlag(boolean flag) {
        this.changed = flag;
    }

    private void enterDragMode() {
        this.interpolator.stop();
        if (!this.isEnabled()) {
            return;
        }
        this.dragged = true;
        this.savedDepth = this.getDepth();
        handle_held = this;
        this.setDepth(-2147483647);
    }

    private void exitDragMode() {
        this.dragged = false;
        handle_held = null;
        this.setDepth(this.savedDepth);
        if (this.revert) {
            this.revert();
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.mouseInRegion) {
            this.setColor(this.C_DRAGGED);
        } else {
            this.revertColor();
        }
    }

    public void setDragColor(Color c) {
        this.C_DRAGGED = c;
    }

    public void setHoming(boolean flag) {
        this.revert = flag;
    }

    @Override
    public void enable() {
        super.enable();
    }

    @Override
    public void disable() {
        super.disable();
        this.revertColor();
    }

    public void ensureBounds() {
        this.setX(MathB.max((double)this.min_x, MathB.min((double)this.max_x, this.getX())));
        this.setY(MathB.max((double)this.min_y, MathB.min((double)this.max_y, this.getY())));
    }

    public void setMinX(int x) {
        this.min_x = x;
        this.initialized = true;
    }

    public void setMaxX(int x) {
        this.max_x = x;
        this.initialized = true;
    }

    public void setMinY(int y) {
        this.min_y = y;
        this.initialized = true;
    }

    public void setMaxY(int y) {
        this.max_y = y;
        this.initialized = true;
    }

    public int getMinX() {
        return this.min_x;
    }

    public int getMaxX() {
        return this.max_x;
    }

    public int getMinY() {
        return this.min_y;
    }

    public int getMaxY() {
        return this.max_y;
    }

    public void fixX(int x) {
        this.setMinX(x);
        this.setMaxX(x);
    }

    public void fixY(int y) {
        this.setMinY(y);
        this.setMaxY(y);
    }

    public double getXPercentage() {
        return 1.0 * (this.getX() - (double)this.min_x) / (double)(this.max_x - this.min_x);
    }

    public double getYPercentage() {
        return 1.0 * (this.getY() - (double)this.min_y) / (double)(this.max_y - this.min_y);
    }

    public boolean isHeld() {
        return handle_held == this;
    }

    protected int getHoldX() {
        return this.holdX;
    }

    protected int getHoldY() {
        return this.holdY;
    }
}

